
 \def\RCSfile{ifs-sc}%
 \def\RCSversion{2.4}%
 \def\RCSdate{2024/05/04}%
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{\RCSfile}[\RCSdate, \RCSversion: Formatting class
   for IFS single column articles]
%
\def\ABD{\AtBeginDocument}
%
% switches
%
\newif\iflongmktitle    \longmktitlefalse
\newif\ifdc             \global\dcfalse
\newif\ifsc             \global\sctrue
\newif\ififsreviewlayout  \global\ifsreviewlayoutfalse
\newif\ififsfinallayout   \global\ifsfinallayoutfalse

\newcounter{blind}
\setcounter{blind}{0}

\def\blstr#1{\gdef\@blstr{#1}}
\def\@blstr{1}
\newdimen\@bls
\@bls=\baselineskip

\DeclareOption{singleblind}{\setcounter{blind}{1}}
\DeclareOption{doubleblind}{\setcounter{blind}{2}}
\DeclareOption{longmktitle}{\global\longmktitletrue}
\DeclareOption{final}{\global\ifsfinallayouttrue}
\DeclareOption{review}{\global\ifsreviewlayouttrue}

\ExecuteOptions{a4paper,10pt,oneside,fleqn}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions
\LoadClass{article}

\RequirePackage{graphicx}
\RequirePackage{amsmath,amsfonts,amssymb}
\allowdisplaybreaks

\RequirePackage{expl3,xparse}
\@ifundefined{regex_match:nnTF}{\RequirePackage{l3regex}}{}
\RequirePackage{etoolbox}
\RequirePackage{booktabs,makecell,multirow,array,colortbl,dcolumn,stfloats}
\RequirePackage{xspace,xstring,footmisc}
\RequirePackage[svgnames,dvipsnames]{xcolor}

\ifbool{ifsreviewlayout}{\RequirePackage{setspace}}{}

\RequirePackage[colorlinks]{hyperref}
\colorlet{scolor}{black}
\colorlet{hscolor}{DarkSlateGrey}
\hypersetup{%
  pdfcreator={LaTeX3; ifs-sc.cls; hyperref.sty},
  pdfproducer={pdfTeX;},
  linkcolor={hscolor},
  urlcolor={hscolor},
  citecolor={hscolor},
  filecolor={hscolor},
  menucolor={hscolor},
}
% \AtEndDocument{\hypersetup
%   {pdftitle={\csuse{__short_title:}},
%   pdfauthor={\csuse{__short_authors:}}}}

 \let\comma\@empty
\let\tnotesep\@empty
\let\@title\@empty
%
% Load Common items
%

\RequirePackage{ifs-common}

%
% Specific to Single Column
%
\ExplSyntaxOn

\RenewDocumentCommand \maketitle {}
{
  \ifbool { useifsgrabsbox }
    {
      \setcounter{page}{0}
      \thispagestyle{empty}
      \unvbox\ifsgrabsbox
    } { }
  \pagebreak
  \ifbool { useifshlsbox }
    {
      \setcounter{page}{0}
      \thispagestyle{empty}
      \unvbox\ifsauhlbox
    } { }
  \pagebreak
  \thispagestyle{first}
  \ifbool{longmktitle}
  {
    \ifnum\theblind>0\relax
        \LongMaketitleBox[blind]
    \else
		\LongMaketitleBox
    \fi
    \ProcessLongTitleBox
  }
  {
    \ifnum\theblind>0\relax
        \MaketitleBox[blind]
    \else
		\MaketitleBox
    \fi
    \printFirstPageNotes
  }
  \normalcolor \normalfont
  \setcounter{footnote}{\int_use:N \g_stm_fnote_int}
  \renewcommand\thefootnote{\arabic{footnote}}
  \gdef\@pdfauthor{\infoauthors}
  \gdef\@pdfsubject{Complex ~STM ~Content}
  \ifbool{ifsreviewlayout}{\doublespacing}{}
}

%
% Fonts
%
\RequirePackage[T1]{fontenc}

\file_if_exist:nTF { stix.sty }
{
  \file_if_exist:nTF { charis.sty }
  {
    \RequirePackage[notext]{stix}
    \RequirePackage{charis}
  }
  { \RequirePackage{stix} }
}
{
  \iow_term:x {  *********************************************************** }
  \iow_term:x { ~Stix ~ and ~ Charis~ fonts ~ are ~ not ~ available ~ }
  \iow_term:x { ~ in ~TeX~system.~Hence~CMR~ fonts~ are ~ used. }
  \iow_term:x {  *********************************************************** }
}

\file_if_exist:nTF { inconsolata }
{ \RequirePackage[scaled=.85]{inconsolata} }
{ \tex_gdef:D \ttdefault { cmtt } }

\ExplSyntaxOff

%
% Page geometry
%

\usepackage[%
  paperwidth=192mm,
  paperheight=262mm,
%  vmargin={12.4mm,11.5mm},
  vmargin={19mm,19mm},
  hmargin={13.7mm,13.7mm},
  headsep=12pt,
  footskip=12pt,
]{geometry}


\endinput

%
% End
